<?php
// $Id: search-block-form.tpl.php,v 1.4 2010/06/03 13:18:48 dries Exp $

/**
 * @file
 * Default theme implementation for displaying a search form within a block
 * region.
 *
 * Available variables:
 * - $search_form: The complete search form ready for print.
 * - $search: Array of keyed search elements. Can be used to print each form
 *   element separately.
 *
 * Default keys within $search:
 * - $search['search_block_form']: Text input area wrapped in a div.
 * - $search['submit']: Form submit button.
 * - $search['hidden']: Hidden form elements. Used to validate forms when submitted.
 *
 * Since $search is keyed, a direct print of the form element is possible.
 * Modules can add to the search form so it is recommended to check for their
 * existence before printing. The default keys will always exist.
 *
 *   <?php if (isset($search['extra_field'])): ?>
 *     <div class="extra-field">
 *       <?php print $search['extra_field']; ?>
 *     </div>
 *   <?php endif; ?>
 *
 * To check for all available data within $search, use the code below.
 *
 *   <?php print '<pre>'. check_plain(print_r($search, 1)) .'</pre>'; ?>
 *
 * @see template_preprocess_search_block_form()
 */
 
 // we use OUTTAG according to code semantic settings
 
 
?>
<div class="container-inline">
  <?php if (empty($variables['form']['#block']->title)) : ?>
    <?php print '<'.OUTTAG.' class="element-invisible">'.t('Search form').'</'.OUTTAG.'>'; ?>
  <?php endif; ?>
  <?php print $search_form; ?>
</div>

