<?php // $Id$

/**
 * Generate markup for marinelli's banners.
 *
 * @return <string>
 *    HTML markup to printo into page
 */
function marinelli_banners_markup($banners) {
  if ($banners) {
    // Add javascript to manage banners
    marinelli_banners_add_js(count($banners));

    // Generate HTML markup for banners
    return marinelli_banner_markup($banners);
  } else {
    return '';
  }
}

/**
 * Add JS required to manage banner into this page.
 *
 * @param <int> $num_banners
 *    Number of banner visible into this page
 */
function marinelli_banners_add_js($num_banners) {
  // in this two cases we do not need cycle, we use a small script to fill banner text
  if ($num_banners <= 1) { // banners match only url
     drupal_add_js(path_to_theme() . '/js/banner/marinelli_banner_text.js');
  }
  // adds cycle passing some parameters
  else {
    // add the required javascript
    drupal_add_js(path_to_theme() . '/js/cycle/cycle.js');
    drupal_add_js(path_to_theme() . '/js/banner/marinelli_configure_cycle.js');

    // pass the text variables to javascript
    drupal_add_js(
      array(
        'marinelli' => array(
          'banner_effect' => theme_get_setting('banner_effect'),
          'banner_speed'  => theme_get_setting('banner_speed'),
          'banner_delay'  => theme_get_setting('banner_delay'),
          'banner_pause'  => theme_get_setting('banner_pause') == 1 ? 1 : 0,
        )
      ),
      array('type' => 'setting')
    );
  }
}

/**
 * Generate banners markup.
 *
 * @return <string>
 *    HTML code to display banner markup.
 */
function marinelli_banner_markup($banners) {
  $output = '';
  $i=0;
  foreach($banners as $banner) {
  	$i!=0 ? $class = ' marinelli-hide-no-js' : $class = "";
    $variables = array(
      'path'  => $banner['image_path'],
      'title' => $banner['image_title'],
      'alt'   => $banner['image_description'],
      'attributes' => array(
        'class' => 'slide'.$class.'', // hide all the slides except #1
        'id'=>'slide-number-'.$i.''
      ),
    );
    // Draw image
    $image   = theme('image', $variables);

    // Remove link if is the same page
    $banner['image_url'] = ($banner['image_url'] == current_path()) ? FALSE  : $banner['image_url'];

    // Add link (if required)
    $output .= $banner['image_url'] ? l($image, $banner['image_url'], array('html' => TRUE)) : $image;
  $i++;
  }
  return $output;
}

/**
 * Get banner to show into current page in accord with settings
 *
 * @return <array>
 *    Banners to show
 */
function marinelli_show_banners() {
  $banners = marinelli_get_banner(FALSE);

  if (drupal_is_front_page()) {
    // Get banners for home page visulalization
    $setting = theme_get_setting('banner_home');
    return marinelli_get_banner_by_config($setting);
  }
  else {
    // Check if some banner match
    $match = FALSE;
    $banners = marinelli_get_banner();
    
    foreach ($banners as $banner) {
      if ($banner['image_url'] == current_path()) {
        $match = TRUE;
        break;
      }
    }

    // Generate settings
    if ($match) {
      $setting = theme_get_setting('banner_matching');
    } else {
      $setting = theme_get_setting('banner_other');
    }

    // Get banners
    return marinelli_get_banner_by_config($setting);
  }
}

/**
 * Get banners to show by settings.
 *
 * @param <int> $setting
 *    Setting to choise type of banner array to show
 *
 * @return <array>
 *    Banners to show
 */
function marinelli_get_banner_by_config($setting) {
  $banners = marinelli_get_banner(FALSE);
  $display_banners = array();

  switch ($setting) {
    case 0: // hide
      return array();
    case 1: // all
      return $banners;
    case 2: // matching
      foreach ($banners as $banner) {
        if ($banner['image_url'] == current_path()) {
          $display_banners[] = $banner;
        }
      }
      return $display_banners;
    case 3: // default
      foreach ($banners as $banner) {
        if ($banner['image_default']) {
          $display_banners[] = $banner;
        }
      }
      return $display_banners;
  }
}