/**
 * Top region js
 * bartext and bartext2 come from theme settings through template.php
 */
jQuery(document).ready(function($) {
  // Hide region
	$('#topBar').hide();
  
	// Make the spy effect
	$('#topBarLink a').live('mouseover mouseout', function(event) {
    if (event.type == 'mouseover' && $(this).text() == "↓ " + Drupal.settings.marinelli.bartext + "") {
      $('#topBarLink').animate({
        'padding-top':'5px'
      });
    }
    else if (event.type == 'mouseout' && $(this).text() == "↓ " + Drupal.settings.marinelli.bartext + "") {
    $('#topBarLink').animate({
      'padding-top':'0px'
    });
    }
	});
  
	// Click logics
	$('#topBarLink a').click(function () {
    if ($(this).text()=="↓ " + Drupal.settings.marinelli.bartext + "") {
      $(this).text("↑ " + Drupal.settings.marinelli.bartext2 + "");
      $(this).attr('title','Close this region');
    }
    else if ($(this).text()=="↑ " + Drupal.settings.marinelli.bartext2 + "") {
      $(this).text("↓ " + Drupal.settings.marinelli.bartext + "");
      $(this).attr('title','Open this region');
    }
    $('#topBar').slideToggle("slow");
    return false;
  });

	// Link positioning
	var linkWidth = $('#topBarLink a').width();
	var windowWidth = $(window).width();

  	// Set start margin
	$('#topBarLink a').css('margin-left', ((windowWidth / 2) - (linkWidth / 2)) + 'px');

	$(window).bind('resize', function(event) {
		$('#topBarLink a').css('margin-left', ($(window).width() / 2) - (linkWidth / 2) + 'px');
	});

});