<?php
/**
 * Implements hook_form_system_theme_settings_alter().
 *
 * @param $form
 *   Nested array of form elements that comprise the form.
 * @param $form_state
 *   A keyed array containing the current state of the form.
 */
function cm_theme_zen_form_system_theme_settings_alter(&$form, &$form_state, $form_id = NULL)  {
  // Work-around for a core bug affecting admin themes. See issue #943212.
  if (isset($form_id)) {
    return;
  }
  
  $form['theme_settings']['dropshadow_classes'] = array(
    '#type' => 'textarea',
    '#title' => t('Apply Dropshadow to the Following CSS Classes and IDs'),
    '#rows' => 10,
    '#default_value' => theme_get_setting('dropshadow_classes'),
    '#description' => t('By default dropshadows are applied to select classes and id to give the theme depth.  You can add or remove items from this comma seperated list.'),
  );
      
  // Create the form using Forms API: http://api.drupal.org/api/7

  /* -- Delete this line if you want to use this setting
  $form['cm_theme_zen_example'] = array(
    '#type'          => 'checkbox',
    '#title'         => t('cm_theme_zen sample setting'),
    '#default_value' => theme_get_setting('cm_theme_zen_example'),
    '#description'   => t("This option doesn't do anything; it's just an example."),
  );
  // */

  // Remove some of the base theme's settings.
  /* -- Delete this line if you want to turn off this setting.
  unset($form['themedev']['zen_wireframes']); // We don't need to toggle wireframes on this site.
  // */

  // We are editing the $form in place, so we don't need to return anything.
}
