<html>
<head>
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <script src="https://code.highcharts.com/highcharts.js"></script>
    <script src="https://code.highcharts.com/modules/exporting.js"></script>
</head>
<?php
	$dbhost = 'localhost' ;
	$dbuser = 'jklgreek_test' ;
	$dbpass = 'test123' ;
	$dbname = 'jklgreek_seeding' ;
	$boxid  = '2C:3A:E8:0F:26:9B' ;   //'5C:CF:7F:12:14:ED' ;
	$soil_moisture_bais = 740 ;
	$soil_moisture_div = 400 ;
	if (isset($_GET['soildiv'])) {
	    $soil_moisture_div = $_GET['soildiv'] ;
	}
	if (isset($_GET['soilb'])) {
	    $soil_moisture_bais = $_GET['soilb'] ;
	}
	if (isset($_GET['bid'])) {
	    $boxid = $_GET['bid'] ;
	}
	$num_of_point = 50;
	if (isset($_GET['n'])) {
	    $num_of_point = $_GET['n'] ;
	}
	$time_stamp_end = 0;
	if (isset($_GET['tend'])) {
	    $time_stamp_end = $_GET['tend'] ;
	}
	
	

	$mysqli = new mysqli($dbhost , $dbuser , $dbpass , $dbname) ;
	/* check connection */
	if ($mysqli->connect_errno) {
	    printf("Connect failed: %s\n", $mysqli->connect_error) ;
	    exit();
	}

        if ($time_stamp_end == 0) {
            $ssql = "SELECT * FROM plant_box_min15 where boxid= '" . $boxid . "' ORDER BY time_stamp DESC LIMIT 0 , " . $num_of_point ."" ;
        } else {
            $ssql = "SELECT * FROM plant_box_min15 where `boxid`='" . $boxid . "' and `time_stamp`<'" . $time_stamp_end . "' ORDER BY time_stamp DESC LIMIT 0 , " . $num_of_point ."" ;
        }
	/* Select queries return a resultset */
	if ($result = $mysqli->query($ssql)) {
	    printf("Select returned %d rows.\n", $result->num_rows);

	    $rec_num = 0 ;
	    foreach ($result as $bb) {
	        $xx[$rec_num]           = $bb['time_stamp'] ; 
            $qty[$rec_num]          = $bb['temperature_qty'] ; 
            
	        $ytemperature[$rec_num]     = round( $bb['temperature_total'] / 100 / $qty[$rec_num],2 ) ;
       	    $yhumidity[$rec_num]        = round( $bb['humidity_total'] / 100 / $qty[$rec_num],2 ) ;
	        $ylight[$rec_num]           = round( $bb['light_total'] / $qty[$rec_num],2 ) ;
	        $ysoil_moisture[$rec_num]   = round( $bb['soil_moisture_total'] / $qty[$rec_num],2 ) ;

	        $rec_num++;
	    }

	    /* free result set */
	    $result->close();
	}

	$mysqli->close();
    $dd = $xx[0];   //$dd = date("Y-m-d", $xx[0]) ;



?>
<body>
<div id="container" style="min-width: 310px; height: 400px; margin: 0 auto"></div>
<script type="text/javascript">
Highcharts.chart('container', {
    chart: {
        zoomType: 'xy'
    },
    title: {
        text: '环境-5分钟 <?php print($dd); ?>'
    },
    subtitle: {
        text: '数据来源: 成都航空职业技术学院-绿色改造 ( <?php print($boxid); ?> ) 框'
    },
    xAxis: [{
        categories: [<?php         
                               for ($i=$rec_num-1 ; $i>=0 ; $i--) {
                                   //print("'". date("G:i:s", $xx[$i])  . "'");  print(',');
                                   print("'". $xx[$i] . " (" .$qty[$i] . ")". "'");  print(',');
                               }             
                           ?>],
        crosshair: true
    }],
    yAxis: [{ // Primary yAxis
        labels: {
            format: '{value}°C',
            style: {
                color: Highcharts.getOptions().colors[2]
            }
        },
        title: {
            text: '温度',
            style: {
                color: Highcharts.getOptions().colors[2]
            }
        },
        opposite: true

    }, { // Secondary yAxis
        gridLineWidth: 0,
        title: {
            text: '泥土 (300-700)',
            style: {
                color: Highcharts.getOptions().colors[0]
            }
        },
        labels: {
            format: '{value}  ',
            style: {
                color: Highcharts.getOptions().colors[0]
            }
        }

    }, { // Tertiary yAxis
        gridLineWidth: 0,
        title: {
            text: '湿度',
            style: {
                color: Highcharts.getOptions().colors[1]
            }
        },
        labels: {
            format: '{value} %',
            style: {
                color: Highcharts.getOptions().colors[1]
            }
        },
        opposite: true
    }, { // 4yh yAxis
        gridLineWidth: 0,
        title: {
            text: '光',
            style: {
                color: Highcharts.getOptions().colors[3]
            }
        },
        labels: {
            format: '{value} lx',
            style: {
                color: Highcharts.getOptions().colors[3]
            }
        },
        opposite: true
    }],
    tooltip: {
        shared: true
    },
    legend: {
        layout: 'vertical',
        align: 'left',
        x: 80,
        verticalAlign: 'top',
        y: 55,
        floating: true,
        backgroundColor: (Highcharts.theme && Highcharts.theme.legendBackgroundColor) || '#FFFFFF'
    },
    series: [{
        name: '泥土',
        type: 'column',
        yAxis: 1,
        data: [<?php    for ($i=$rec_num-1 ; $i>=0 ; $i--) {
                            //        print( ((740-$ysoil_moisture[$i])/400)*100 ) ;      print(',');
                            print( round((($soil_moisture_bais-$ysoil_moisture[$i])/$soil_moisture_div)*10000)/100 ) ;      print(',');
                        }
                ?>],
        tooltip: {
            valueSuffix: ' %'
        }

    }, {
        name: '湿度',
        type: 'spline',
        yAxis: 2,
        data: [<?php         for ($i=$rec_num-1 ; $i>=0 ; $i--) {
                                    print( $yhumidity[$i] ) ;      print(',');
                                 }
                ?>],
        marker: {
            enabled: false
        },
        dashStyle: 'shortdot',
        tooltip: {
            valueSuffix: ' %'
        }

    }, {
        name: '温度',
        type: 'spline',
        yAxis: 0,
        data: [<?php         for ($i=$rec_num-1 ; $i>=0 ; $i--) {
                                    print( $ytemperature[$i] ) ;      print(',');
                                 }
                ?>],
        dashStyle: 'shortdot',
        tooltip: {
            valueSuffix: ' °C'
        }
    }, {
        name: '光',
        type: 'spline',
        yAxis: 3,
        data: [<?php         for ($i=$rec_num-1 ; $i>=0 ; $i--) {
                                    print( $ylight[$i] ) ;      print(',');
                                 }
                ?>],
        dashStyle: 'shortdot',
        tooltip: {
            valueSuffix: ' lx'
        }

    }]
});








</script>

</body>
</html>